
' ----- ExeScript Options Begin -----
' ScriptType: window
' DestDirectory: temp
' Icon: default
' OutputFile: C:\Documents and Settings\chrisrodo\Desktop\sys_info.exe
' ----- ExeScript Options End -----
' This code prints system information similar to the systeminfo command.
' ---------------------------------------------------------------
' From the book "Windows Server Cookbook" by Robbie Allen
' ISBN: 0-596-00633-0
' ---------------------------------------------------------------

' ------ SCRIPT CONFIGURATION ------
strComputer = "."   ' e.g. rallen-srv01
' ------ END CONFIGURATION ---------
Dim filename1
Dim filename2
MsgBox "           ." & _
vbCr & vbLf & "       ." & vbCr & vbLf & _
 "!! TE        !!"
Dim stationname
Dim uni
set dicProductType = CreateObject("Scripting.Dictionary")
dicProductType.Add 1, "Workstation"
dicProductType.Add 2, "Domain Controller"
dicProductType.Add 3, "Standalone Server"
Dim info
set objWMIDateTime = CreateObject("WbemScripting.SWbemDateTime")

set objWMI = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")
set colOS = objWMI.InstancesOf("Win32_OperatingSystem")
for each objOS in colOS
	 stationname=objOS.CSName
   info=info & objOS.CSName & ";"
   info=info & objOS.Caption & ";"
   info=info & objOS.Version & " Build " & objOS.BuildNumber & ";"
   info=info & objOS.Manufacturer & ";"
   info=info & dicProductType.Item(objOS.ProductType) & ";"
   info=info & objOS.BuildType & ";"
   info=info & objOS.RegisteredUser & ";"
   info=info & objOS.Organization & ";"
   info=info & objOS.SerialNumber & ";"
   objWMIDateTime.Value = objOS.InstallDate
   info=info & objWMIDateTime.GetVarDate & ";"
   objWMIDateTime.Value = objOS.LastBootUpTime 
   info=info & objWMIDateTime.GetVarDate & ";"
   info=info & objOS.WindowsDirectory & ";"
   info=info & objOS.SystemDirectory & ";"
   info=info & objOS.BootDevice & ";"
   info=info & objOS.Locale & ";"
   info=info & "GMT " & objOS.CurrentTimezone & ";"
   info=info & round(objOS.TotalVisibleMemorySize / 1024) & ";"
   info=info & round(objOS.FreePhysicalMemory / 1024) & ";"
   info=info & round(objOS.TotalVirtualMemorySize / 1024)  & ";"
   info=info & round(objOS.FreeVirtualMemory / 1024) & ";"
   Exit For
next

set colCS = objWMI.InstancesOf("Win32_ComputerSystem")
for each objCS in colCS
   info=info & objCS.Manufacturer & ";"
   info=info & objCS.Model & ";"
   info=info & objCS.SystemType & ";"
   info=info & objCS.Domain & ";"
   info=info & objCS.NumberofProcessors & ";"
   Exit For
next

intCount = 0
set colProcs = objWMI.InstancesOf("Win32_Processor")
for each objProc in colProcs
   intCount = intCount + 1
   info=info & objProc.Caption & " ~" & objProc.MaxClockSpeed & "Mhz" & ";"
   'uni=objProc.ProcessorId
   Exit For
  ' MsgBox uni
next

set colBIOS = objWMI.InstancesOf("Win32_BIOS")
for each objBIOS in colBIOS 
   info=info & objBIOS.Version & ";"
   Exit For
Next

totalSize=0
totalFreeSize=0

set colHDD = objWMI.InstancesOf("Win32_LogicalDisk Where DriveType = '3'")
For each objHDD in colHDD
  
     'Wscript.Echo "DeviceID: " & objHDD.DeviceID      
     'Wscript.Echo "TotalSize: " & FormatNumber(objHDD.Size/ (1024 * 1024 * 1024), 2,0,0,0)  
     'Wscript.Echo "FreeSpace: " & FormatNumber(objHDD.FreeSpace / (1024 * 1024 * 1024), 2,0,0,0)    
     totalSize=totalSize+FormatNumber(objHDD.Size/ (1024 * 1024 * 1024), 2,0,0,0)
     totalFreeSize=totalFreeSize+FormatNumber(objHDD.FreeSpace / (1024 * 1024 * 1024), 2,0,0,0)
Next

     'Wscript.Echo "totalDISKSSize:" & totalSize
     'Wscript.Echo "totalFreeDISKSSize:" & totalFreeSize
info=info & totalSize & " GB;"
info=info & totalFreeSize & " GB;"


info=info & now
Set objFSOe = CreateObject("Scripting.FileSystemObject")
Set colDrives3 = objFSOe.Drives
Set objDrive3 = colDrives3.item("c:\")
uni=objDrive3.SerialNumber


filename1="Hardware_" & stationname & "_" & "v2_" & uni &".nfo"
filename2="Software_" & stationname & "_" & "v2_" & uni &".nfo"
Set objFSO2 = CreateObject("Scripting.FileSystemObject")
Set objTextFile2 = objFSO2.CreateTextFile(filename1, True)

objTextFile2.WriteLine "Host_Name;OS_Name;OS_Version;OS_Manufacturer;OS_Configuration;OS_Build_Type;Registered_Owner;Registered_Company;ProductID;Original_Install_Date;System_Up_Time;Windows_Directory;System_Directory" & ";" & "BootDevice" & ";" & _
    "System_Locale" & ";" & "Time_Zone_GMT" & ";" & "Total_Physical_Memory_MB" & ";" & "Available_Physical_Memory_MB" & ";" & "page_File_Max_Size_MB" & ";" _
      & "Page_File_Available_MB" & ";" & "System_Manufacturer" & ";" & "System_Model" & ";" & "System_Type" & ";" & "Domain" & ";" & "Processors" & ";" & "Processor_Speed" & _
      ";" & "BIOS_VERSION" & ";" & "HDD-PARTITION1 TOTAL SIZE" & ";" & "HDD-PARTITION1 FREE SIZE" & ";" & "DATE_RECORDED"
objTextFile2.WriteLine info
objTextFile2.Close
'=======================================================
Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objTextFile = objFSO.CreateTextFile(filename2, True)
strComputer = "."
Set objWMIService = GetObject("winmgmts:" _
    & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
Set colSoftware = objWMIService.ExecQuery _
    ("Select * from Win32_Product")
objTextFile.WriteLine "Caption" & ";" & _
    "Description" & ";" & "Identifying Number" & ";" & _
    "Install Date" & ";" & "Install Location" & ";" & _
    "Install State" & ";" & "Name" & ";" & _ 
    "Package Cache" & ";" & "SKU Number" & ";" & "Vendor" & ";" _
        & "Version" 
For Each objSoftware in colSoftware
    objTextFile.WriteLine objSoftware.Caption & ";" & _
    objSoftware.Description & ";" & _
    objSoftware.IdentifyingNumber & ";" & _
    objSoftware.InstallDate2 & ";" & _
    objSoftware.InstallLocation & ";" & _
    objSoftware.InstallState & ";" & _
    objSoftware.Name & ";" & _
    objSoftware.PackageCache & ";" & _
    objSoftware.SKUNumber & ";" & _
    objSoftware.Vendor & ";" & _
    objSoftware.Version
Next
MsgBox "     " & vbCr & vbLf & "   "
objTextFile.Close
